<?php
/*
	DevSaver web framework
	copyright (c) 2013-2016 DevSaver
		web:  www.devsaver.com
		mail: support@devsaver.com

	$Id: blog/site.php,v 1.0 3/16/2014  11:00:00 DevSaver Exp $
	description
*/

// dependencies

/**
* description
*
* @library	
* @author Emanuel Giurgea ( emanuel@devsaver.com )
* @since 
*/
class CBlog extends CPlugin{
	
	var $tplvars; 

	function __constructor() {
		$this->name = "blog";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {


			$this->__init();
			$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();

			$this->plugins["globalhooks"]->SetModule($this->tpl_module);
			$this->LoadLabels();

			$this->plugins["seo"]->AppendToHead("\t\t" . '<link rel="alternate" type="application/rss+xml" title="' . $this->tpl_module["settings"]["set_rss_title"] . '" href="' . $this->tpl_module["link"] .'rss" />');

			switch ($_GET["sub"]) {
				case "topics":
				case "search":
				case "label":
				case "archive":
				case "author":
					return $this->Topics();
				break;

				case "topic":
					return $this->Topic();
				break;

				case "rss":
					return $this->Rss();
				break;


				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"topic"					=> "topic.htm",
			"list"					=> "topics.htm",

			"image"					=> "image.htm",

			"author"				=> "author.htm",

			"rss"					=> "rss.xml",

			"menu"					=> "menu.htm",

		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

	} 
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Topics() {

		global $base;

		$meta = $this->GetTopicsMeta();
		$text = $this->PageTitleBlock($meta["breadcrumb"]);


		if ($meta["error"]) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}
		

		$items = $this->GetItems(array(
			"items"		=> $this->tpl_module["settings"]["set_ipp_items"] , 
			"page"		=> $_GET["page"],
			"cond"		=> $meta["cond"],
		));

		$items["records"] = $this->ProcessItems($items["records"] , $items , $meta["cond"]);

		$template = &$this->private->templates["list"];

		if ($this->tpl_module["settings"]["set_style"] == "blog-topics-clasic") {
			$this->tpl_module["settings"]["set_size"] = 
			$this->tpl_module["settings"]["set_size_lg"] = 
			$this->tpl_module["settings"]["set_size_md"] = 
			$this->tpl_module["settings"]["set_size_sm"] = 
			$this->tpl_module["settings"]["set_size_xs"] = "12";
		}

		$this->SetComments($this->tpl_module["settings"]["set_comments"], array("link" => $meta["link_first"]));


		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$meta["layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$items["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$items["pages"] , 
						$items["page"] , 
						array(
							"first"	=> $meta["link_first"] ,
							"all"	=> $meta["link_all"],
						),
						$items["items"]
					),

					"title"			=> $meta["title"],
					"description"	=> $meta["description"] ? $template->blockReplace("Header" , $meta) : "",

					"header"		=> $meta["header"],

				),
				$this->tpl_module,
				$this->tpl_module["settings"]		
			)
		);
	}	


	function GetItems($params = array()) {
		global $_SESS;
	
		$count	= max(1,$params["items"]);
		$page	= $params["page"];

		$order		= "item_date";
		$order_mode = "desc";
		$fields = "*";

		$cond = " 
			c.item_id=l.item_id AND 
			l.lang_id={$this->tpl_module[lang_id]} AND 
			c.module_id={$this->tpl_module[mod_id]} AND 
			item_status=1 AND 
			item_date <= " . time() . " AND 
			c.item_author=a.author_id " . $params["cond"] . " ";

		if (!$_SESS["client"]) {
			$cond .= " AND  item_protect=0 ";
		} 


		if ($_GET["q"]) {
			
			$fields = $this->db->Statement("
				* , 
				MATCH (`item_title`, `item_body` ) AGAINST ('%s' IN BOOLEAN MODE) AS relevance", 
				array($_GET["q"] , $_GET["q"])
			);

			$cond .=  $this->db->Statement( " AND MATCH (item_title , `item_body` ) AGAINST ('%s' IN BOOLEAN MODE) " , array($_GET["q"]));
			$order_mode = "";
			$order = "relevance DESC";
		
		}
		
		

		$item_count = $this->db->RowCount(
			"	{$this->tables['plugin:blog_topics']} as c,
				{$this->tables['plugin:blog_authors']} as a,
				{$this->tables['plugin:blog_topics_lang']} as l
			",
			"	WHERE {$cond}"
		);

		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"SELECT {$fields} " . 
			"FROM 
				{$this->tables['plugin:blog_topics']} as c,
				{$this->tables['plugin:blog_topics_lang']} as l,
				{$this->tables['plugin:blog_authors']} as a

			WHERE 				
				{$cond}
			ORDER BY  {$order} {$order_mode} 
			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);

		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);

	}


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
		* @access
	*/
	function ProcessElements(&$item , $elements , $template, $type = "listing", $settings , $max = 0 , $labels) {
		global $base;

		$item["_author"] = $item["_date"] = $item["_date2"] = $item["_comments"] = $item["_comments2"] = $item["_views"] = $item["_title"] = $item["_brief"] = $item["_button"] = $item["_image"] = $item["_cats"] = "";

		if (in_array("author" , $elements) ) {
			$item["author_link"]	= $this->plugins["modules"]->modules[$item["module_id"]]["link"] . "authors/" . $item["author_url"] . "/" ;

			$item["_author"] = $template->blockReplace(
				"Author" .( $item["author_details"] == "1" ? "Link" : ""), 
				$item
			);
		}
		

		if (in_array("comments" , $elements) && $settings["set_comments"]) {
			$item["item_stats_comments"] = $this->plugins["comments"]->CommentsCount(
				$settings["set_comments"],
				$item["link"],
				$item["item_stats_comments"]
			);

			$item["_comments"] = $template->blockReplace("Comments" , $item);
			$item["_comments2"] = $template->blockExists("Comments2") ? $template->blockReplace("Comments2" , $item) : "";
		} 

		if (in_array("views" , $elements)) {
			$item["item_stats_views"] = FormatNumber($item["item_stats_views"]);
			$item["_views"] = $template->blockReplace(
				"Views" , 
				$item
			);
		} 

		if (in_array("image" , $elements)) {
			$item["_image"] = $this->plugins["media"]->Gallery(
				$item["item_id"] , 
				$item["module_id"] , 
				$type == "listing" ? $item["link"] : "",
				$type , 
				"html" , 
				array(
					"path" => "upload/blog",
					"tn"	=> $settings["set_media_height"] ? "tn2" : "tn",
					"max"	=> $max,
					"display"	=> $type == "details" ? "player" : "gallery",
				)
			);
		}
						
		if (in_array("date" , $elements) ) {

			$item["date"] = CDate::ToStr($settings["set_date"] ,$item["item_date"]);
			$item["time"] = CDate::ToStr("G:i" ,$item["item_date"]);

			$item["day"] = CDate::ToStr("d" ,$item["item_date"]);
			$item["month_3"] = CDate::ToStr("%b" ,$item["item_date"]);
			$item["month"] = CDate::ToStr("%B" ,$item["item_date"]);
			$item["year"] = CDate::ToStr("Y" ,$item["item_date"]);;

			$item["_date"] = $template->blockExists("Date") ? $template->blockReplace("Date" , $item) : "";
			$item["_date2"] = $template->blockExists("Date2") ? $template->blockReplace("Date2" , $item) : "";
		} 

		if ($item["item_labels"]) {

			$tmp = explode("," , $item["item_labels"]);

			$cats = array();

			foreach ($labels as $k => $v) {
				if (in_array($v["label_id"] , $tmp)) {
					$cats[] = $v;
				}					
			}

			if (in_array("cats" , $elements) && is_array($cats) && count($cats)) {
				$item["_cats"] = $template->blockreplace(
					"Cats" , 
					array(
						"data"	=> $base->html->table(
							$template,
							"Cats",
							$cats
						)
					)
				);
			}
			
		}


		if (in_array("brief" , $elements) && $template->blockExists("Brief")) {
			$item["_brief"] = $template->blockReplace(
				"Brief" , 
				$item
			);
		} 

		if (in_array("title" , $elements) && $template->blockExists("Title")) {
			$item["_title"] = $template->blockReplace(
				"Title" , 
				$item
			);
		} 

		if (in_array("button" , $elements) && $template->blockExists("Button")) {
			$item["_button"] = $template->blockReplace(
				"Button" , 
				$item
			);
		} 

				
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items , $category) {
		global $base;


		if (is_array($items)) {

			$template = &$this->private->templates["list"];
			$elements = explode("," , $this->tpl_module["settings"]["set_elements"]);


			foreach ($items as $key => $val) {

				$val["link"] = $items[$key]["link"] = $this->tpl_module["link"] . $val["item_url"] . "/" . $val["item_id"] ;
				$val["module_link"] = $this->tpl_module["link"];

				$this->ProcessElements($items[$key] , $elements , $template , "listing" , $this->tpl_module["settings"], "" , $this->labels);
				


				$items[$key]["social_links"] = $this->plugins["socialmedia"] && $this->tpl_module["settings"]["set_social_list"] ? $this->plugins["socialmedia"]->Share($val["link"] , $val["item_title"]) : "";
		
				
			}
			
		}
		

		return $items;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Topic() {
		global $base , $_SESS;

		//first table must be the author as the seo fiels will be overwritted by the blog.
		$topic = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:blog_authors']} as a , 
				{$this->tables['plugin:blog_authors_lang']} as al , 
				{$this->tables['plugin:blog_topics']} as t , 
				{$this->tables['plugin:blog_topics_lang']} as tl 
				
			WHERE
				t.item_id = tl.item_id AND 
				tl.lang_id = {$this->tpl_module[lang_id]} AND 
				a.author_id = al.author_id AND 
				t.item_author=a.author_id AND 
				al.lang_id = {$this->tpl_module[lang_id]} AND 
				t.module_id = {$this->tpl_module[mod_id]} AND
				t.item_id = %d AND

				t.item_status = 1 AND 
				t.item_date <= " . time() . "  
				" . ( $_SESS["client"] ? "" : " AND item_protect=0 ") . "

			",
			array($_GET["topic"])
		);


		if (!is_array($topic)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}

		//update the topic views
		$this->db->QueryUpdate(
			$this->tables["plugin:blog_topics"],
			array(
				"item_stats_views"	=> $topic["item_stats_views"] + 1
			),
			"item_id={$topic[item_id]}"
		);

		//process the link 
		$topic["link"] = $this->tpl_module["link"] . $topic["item_url"] . "/" . $topic["item_id"];

		$this->plugins["seo"]->PageMeta($topic);
		$this->plugins["seo"]->Canonical($topic["link"]);
		$this->plugins["media"]->OpenGraph($topic["item_id"], $topic["module_id"]);
		$this->plugins["seo"]->OpenGraph(array("og:type" => "article"));

		$text = $this->PageTitleBlock(
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"],
				$topic["link"]				=> $topic["item_title"],
			)
		);


		$template = &$this->private->templates["topic"];
		$elements = explode("," , $this->tpl_module["settings"]["set_elements_details"]);
				
		$this->ProcessElements(
			$topic , 
			$elements,
			$template , 
			"details" , 
			array_merge(
				$this->tpl_module["settings"],
				array(
					"set_media_height"	=> $this->tpl_module["settings"]["set_media_height_details"]
				)
			), 
			"" , 
			$this->labels
		);


		//$topic["image"]			= $this->ItemImage($topic , "details");
		$topic["social_links"]	= $this->plugins["socialmedia"] && $this->tpl_module["settings"]["set_social_details"] ? $this->plugins["socialmedia"]->Share($topic["link"]) : "";

		$topic["back_link"]		= $this->tpl_module["link"];

		

		$this->SetComments($this->tpl_module["settings"]["set_comments_details"], 
			array(
				"reserved"	=> $topic["item_id"],
				"status"	=> $topic["item_comments"],
				"new"		=> !$topic["item_comments_new"],
			)
		);


		//process the author box
		if (in_array("author" , $elements) && $topic["item_author_box"]) {


			$topic["author_box"] = $this->_t("author")->blockReplace(
				"Author" , 
				$topic , 
				array(
					"title"	=> $this->_t("author")->blockReplace($topic["author_details"] ? "TitleLink" : "TitleNoLink" , $topic),
					"photo"		=> $this->_t("author")->blockReplace(
						$topic["author_image"] ? "Image" : "NoImage",
						$topic
					),
					"social"	=> $this->AuthorSocials($topic),
					"more"		=> $topic["author_details"] ? $this->_t("author")->blockReplace("MoreTopics" , $topic) : "",
				)
			);
		} else {
			$topic["author_box"] = "";
		}
		
		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_topic"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				$topic,
				array(
				),
				$this->tpl_module,
				$this->tpl_module["settings"]		
			)
		);


	}

		
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function LoadLabels($module = array() , $ret = false) {
		global $_LANG_ID;

		$mod_id = $module["mod_id"] ? $module["mod_id"] : $this->tpl_module["mod_id"];

		$labels = $this->db->QFetchRowArray(
			"SELECT 
				*
			FROM 
				{$this->tables['plugin:blog_labels']} as b ,
				{$this->tables['plugin:blog_labels_lang']} as l
			WHERE
				b.label_id=l.label_id AND 
				l.lang_id={$_LANG_ID} AND 
				label_status = 1 AND 
				b.module_id = {$mod_id}
		
			ORDER BY 
				label_order ASC
			"
		);

		if (is_array($labels)) {

			foreach ($labels as $key => $val) {

				$val["link"] = $this->tpl_module["link"] . $val["label_url"] . "/";

				if ($val["label_all"]) {
					$val["link"] = $this->tpl_module["link"];

					$this->default_label = $val;
				} else {
					$val["link"] = $this->tpl_module["link"] . $val["label_url"] . "/";
				}
												
				$_labels[$val["label_id"]] = $val;
			}
		}

		if ($ret) {
			return $_labels;			
		}

		$this->labels = $_labels;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetTopicsMeta() {

		switch ($_GET["sub"]) {

			//latest
			case "topics":

				$text = $this->GetTexts();


				$this->plugins["seo"]->PageMeta(
					$text
				);

				return array(
					"link_first"	=> $this->tpl_module["link"],
					"link_all"		=> $this->tpl_module["link"] . "p{PAGE}/",
					"layout"		=> $this->tpl_module["settings"]["set_layout"],
					"cond"			=> "",

					"title"			=> $text["text_block_1_title"],
					"description"	=> $text["text_header"],


					"breadcrumb"	=> array(
						$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
					)
				);

				
			break;

			case "label":

				if (is_array($this->labels)) {
					foreach ($this->labels as $key => $val) {
						if ($val["label_url"] == $_GET["label"]) {
							$label = $val;
						}						
					}					
				}

				if (!is_array($label)) {
					$error = true;
				}
				

				$this->plugins["seo"]->PageMeta(
					$label
				);

				return array(
					"title"			=> $label["label_title"],
					"link_first"	=> $label["link"],
					"link_all"		=> $label["link"] . "p{PAGE}/",

					"layout"		=> $this->tpl_module["settings"]["set_layout"],
					"error"			=> $error,

					"description"	=> $label["label_desc"],
					"cond"			=> " AND find_in_set({$label['label_id']} , item_labels ) ", 

					"breadcrumb"	=> array(
						$this->tpl_module["link"]	=> $this->tpl_module["mod_name"],
						$label["link"]				=> $label["label_title"]
					)

				);

			break;

			case "search":

				$this->plugins["seo"]->PageMeta(
					array(
						"seo_title"	=> CTemplateStatic::Replace(
							$this->tpl_module["settings"]["lang_search"],
							array(
								"q"		=> urldecode($_GET["q"]),
								"page"	=> $_GET["page"]
							)
						),
						"seo_desc"	=> ""
					)
				);

				$this->plugins["seo"]->AppendToHead("<meta name=\"robots\" content=\"noindex,nofollow\">");

				$title = CTemplateStatic::Replace(
					$this->tpl_module["settings"]["lang_search"],
					array(
						"q"		=> urldecode($_GET["q"]),
						"page"	=> $_GET["page"]
					)
				);

				return array(
					"title"	=> $title,

					"layout"		=> $this->tpl_module["settings"]["set_layout_search"],
					"link_first"	=> $this->tpl_module["link"] . "search/?q=" . $_GET["q"],
					"link_all"	=> $this->tpl_module["link"] . "search/?q=" . $_GET["q"] . "&page={PAGE}",


					"breadcrumb"	=> array(
						$this->tpl_module["link"]									=> $this->tpl_module["mod_name"],
						$this->tpl_module["link"] . "search/?q=" . $_GET["q"]		=> $title,
					)

				);

			break;

			case "archive":
				//do the checks here 

				$this->plugins["seo"]->AppendToHead("<meta name=\"robots\" content=\"noindex,nofollow\">");

				$month = (int)$_GET["month"];
				$year = (int)$_GET["year"];

				if (!(($month >= 1 ) && ($month <= 12)) ) {
					$error = true;
				}
							
				$this->plugins["seo"]->PageMeta(
					array(
						"seo_title"	=> CDate::ToStr("%b" , $date) . " " . $_GET["year"],
						"seo_desc"	=> ""
					)
				);

				return array(
					"title"			=> CDate::ToStr("%B %G" , strtotime( "01.{$_GET[month]}.{$_GET[year]}")),

					"link_first"	=> $this->tpl_module["link"] . "{$_GET[month]}-{$_GET[year]}/",
					"link_all"		=> $this->tpl_module["link"] . "{$_GET[month]}-{$_GET[year]}/p{PAGE}/",

					"layout"		=> $this->tpl_module["settings"]["set_layout_archive"],
					"error"			=> $error,

					"cond"	=> " AND item_date_month = {$month}  AND item_date_year = {$year} ",

					"breadcrumb"	=> array(
						$this->tpl_module["link"]										=> $this->tpl_module["mod_name"],
						$this->tpl_module["link"] . "{$_GET[month]}-{$_GET[year]}/"		=> CDate::ToStr("%B %G" , strtotime( "01.{$_GET[month]}.{$_GET[year]}")),
					)

				);
			break;


			case "author":
				//do the checks here 
				$author = $this->db->QFetchArray(
					"SELECT * FROM 
						{$this->tables['plugin:blog_authors']} as a,
						{$this->tables['plugin:blog_authors_lang']} as al
					WHERE
						a.author_id = al.author_id AND 
						al.lang_id = {$this->tpl_module[lang_id]} AND 
						a.author_url LIKE '%s'
					",
					array($_GET["author"])
				);

				if (!is_array($author)) {
					$error = true;

					$this->plugins["seo"]->PageMeta(
						$author
					);

					$author["author_link"] = $author["link"] = $this->tpl_module["link"] . "authors/{$author[author_url]}/";
				} 

				$this->plugins["seo"]->PageMeta($author);


				$template = &$this->private->templates["author"];


				return array(
					"title"	=> $author["author_name"],
					"error"			=> $error,

					"layout"		=> $this->tpl_module["settings"]["set_layout_author"],
					"link_first"	=> $this->tpl_module["link"] . "authors/{$author[author_url]}/",
					"link_all"		=> $this->tpl_module["link"] . "authors/{$author[author_url]}/p{PAGE}/",

					"header"		=> $template->blockReplace(
						"Main" ,
						$author , 
						array(
							"image"			=> $template->blockReplace($author["author_image"] ? "Image" : "NoImage" , $author),
							"social_links"	=> $this->plugins["socialmedia"] ? $this->plugins["socialmedia"]->Share($author["link"]) : "",	
							"social"		=> $this->AuthorSocials($author),
						)
					),

					"description"	=> "",

					"cond"	=> " AND item_author= {$author[author_id]}  ",


					"breadcrumb"	=> array(
						$this->tpl_module["link"]										=> $this->tpl_module["mod_name"],
						$this->tpl_module["link"] . "authors/{$author[author_url]}/"	=> $author["author_name"]
					)

				);
			break;

		}
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function RSS() {
		global $base , $_CONF , $_LANG_RAW;

		$mime = new CMime();
		$mime->Set("xml");

		$template = &$this->private->templates["rss"];

		$items = $this->db->QFetchRowArray(
			"
				SELECT * FROM 
					{$this->tables['plugin:blog_topics']} as t,
					{$this->tables['plugin:blog_topics_lang']} as tl
				WHERE

					t.item_id = tl.item_id AND 
					tl.lang_id = {$this->tpl_module[lang_id]} AND 
					t.item_status = 1 AND 
					t.item_date <= " . time() . " AND 
					t.item_protect = 0 
				ORDER BY 
					item_date DESC
				LIMIT 10
			"
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$items[$key]["link"] = $this->tpl_module["link"] . "{$val[item_url]}/{$val[item_id]}";
				$items[$key]["date"] = CDate::toStr("r" , $val["item_date"] );
				$items[$key]["item_title"] = utf8_encode(htmlentities($val["item_title"],ENT_COMPAT,'utf-8'));
				$items[$key]["item_brief"] = utf8_encode(htmlentities($val["item_brief"],ENT_COMPAT,'utf-8'));
				$date = max($val["item_date"] , $date);
			}
			
		}
		

		return $template->blockReplace(
			"Main" , 
			array(
				
				"items"	=> $base->html->table(
					$template , 
					"" , 
					$items
				),

				"date"	=> CDate::toStr("r" , $date ),
				"url"	=> $_CONF["url"],

				"lang"	=> $_LANG_RAW["lang_code"],

				"rss_link"	=> $this->tpl_module["link"] . "rss",
			),

			$this->tpl_module["settings"]
		);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCommentPost($comment) {

		if ((int)$comment["comment_reserved"]) {
			$this->db->QueryUpdate(
				$this->tables["plugin:blog_topics"],
				array(
					"item_stats_comments"	=> $this->db->RowCount(
						$this->tables["plugin:comments"],
						"WHERE module_id={$comment[module_id]} AND comment_reserved={$comment[comment_reserved]}" 
					)
				),
				"item_id={$comment[comment_reserved]}"
			);
		}

	}

	function GetMenuButton($module) { 


		switch ($module["settings"]["set_menu_style"]) {
			default:
				return parent::GetMenuButton($module);
			break;

			case "1":

				//labels
				$labels = $this->db->QFetchRowArray(
					"SELECT 
						*
					FROM 
						{$this->tables['plugin:blog_labels']} as b ,
						{$this->tables['plugin:blog_labels_lang']} as l
					WHERE
						b.label_id=l.label_id AND 
						l.lang_id={$module[lang_id]} AND 
						label_status = 1 AND 
						b.module_id = {$module[mod_id]}	AND 
						label_parent = 0
					ORDER BY 
						label_order ASC
					"
				);

				if (is_array($labels)) {

					if ($module["settings"]["set_menu_all"]) {

						$sub[] = array(
							"title"		=> $module["settings"]["lang_all_topics"],
							"link"		=> $module["link"],
							"selected"	=> ($module["mod_id"] == $_GET["module_id"] ) && ($_GET["sub"] == "topics") ? true: false,
							"target"	=> "",
							"html"		=> "",
							"sub"		=> "",
						);
					}
					
					foreach ($labels as $key => $val) {
						$sub[] = array(
							"title"		=> $val["label_title"],
							"link"		=> $module["link"] . $val["label_url"] . "/",
							"selected"	=> ($module["mod_id"] == $val["module_id"] ) && ( $val["label_url"] == $_GET["label"]) ? true : false,
							"target"	=> "",

							"html"		=> "",
							"sub"		=> "",
						);
					}


					return parent::GetMenuButton(
						$module , 
						array( 
							"html"	=> $this->plugins["menus"]->dropDownHTML(								
								array(
									"size"		=> $module["settings"]["set_menu_cols"],
									"id"		=> $module["mod_id"],
									"bg"		=> $module["settings"]["set_menu_bg"],
									"title"		=> $module["mod_name"],
									"pos"		=> $module["mod_pos"],	
								),
								$sub
							)
						)
					);
				}
			break;
		}

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AuthorSocials($item) {
		global $base;

		$links = array();

		for ($i = 1; $i <= 5 ; $i++ ) {

			if ($item["author_social_{$i}_icon"] && $item["author_social_{$i}_link"]) {
				$links[] = array(
					"icon"	=> $item["author_social_{$i}_icon"],
					"link"	=> $item["author_social_{$i}_link"],
				);
			}						
		}

		if (count($links)) {
			
			return $base->html->table(
				$this->_t("author"),
				"Social",
				$links
			);

		}
		
		return "";
		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetMaps($module , $lang) {

		if ($module["mod_id"]) {
			return array($module["mod_id"] => true);
		} else {
			return array($module["module_code"] => true);
		}
		
	}



	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetLinks($module , &$links) {
		
		$links[] = array(
			"url" => $module["link"],
		);

		//labels
		$labels = $this->db->QFetchRowArray(
			"SELECT 
				*
			FROM 
				{$this->tables['plugin:blog_labels']} as b ,
				{$this->tables['plugin:blog_labels_lang']} as l
			WHERE
				b.label_id=l.label_id AND 
				l.lang_id={$module[lang_id]} AND 
				label_status = 1 AND 
				b.module_id = {$module[mod_id]}
		
			ORDER BY 
				label_order ASC
			"
		);

		if (is_array($labels)) {

			foreach ($labels as $key => $val) {

				$links[] = array(
					"url" => $module["link"] . $val["label_url"] . "/"
				);
			}
		}

		$authors = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:blog_authors']} as a,
				{$this->tables['plugin:blog_authors_lang']} as al

			WHERE 
				a.author_id = al.author_id AND 
				al.lang_id = {$module[lang_id]} AND 
				a.module_id = {$module[mod_id]}

			ORDER BY 
				a.author_name ASC
			"
		);

		//authors
		if (is_array($authors)) {
			foreach ($authors as $key => $val) {

				$links[] = array(
					"url" => $module["link"] . "authors/" . $val["author_url"] . "/"
				);

			}
			
		}

		//topics
		$items = $this->db->QFetchRowArray(
			"SELECT 
				item_url, 
				c.item_id ,  
				author_id , 
				author_url ,
				author_details
			FROM 
				{$this->tables['plugin:blog_authors']},
				{$this->tables['plugin:blog_topics']} as c,
				{$this->tables['plugin:blog_topics_lang']} as l

			WHERE 				
				c.item_id=l.item_id AND 
				l.lang_id={$module[lang_id]} AND 
				c.module_id={$module[mod_id]} AND 
				item_status=1 AND 
				item_date <= " . time() . " 
			"
		);


		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$links[] = array(							
					"url"		=> $module["link"] . $val["item_url"] . "/" . $val["item_id"],
				);
			}
			
		}

			
	}


}
